(*
Summarize Message

Copyright © 2003–2013 Apple Inc. All rights reserved.

You may incorporate this Apple sample code into your program(s) without
restriction.  This Apple sample code has been provided "AS IS" and the
responsibility for its operation is yours.  You are not permitted to
redistribute this Apple sample code as "Apple sample code" after having
made changes.  If you're going to redistribute the code, we require that
you make it clear that the code was descended from Apple sample code,
but that you've made changes.
*)

(*
This script takes the selected messages, creates a summary using the
summarize command in the Standard Additions, then speaks the summary
using the say command, also in Standard Additions.
*)

tell application "Mail"
	set selectedMessages to selection
	
	set selectionCount to (count of selectedMessages)
	if selectionCount is greater than 1 then
		set speakString to "There are " & selectionCount & " selected messages." & return
	else if selectionCount is equal to 1 then
		set speakString to "There is " & selectionCount & " selected message." & return
	else -- selectionCount is less than or equal to 0
		set speakString to "There are no selected messages."
	end if
	
	repeat with messageNumber from 1 to selectionCount
		set theMessage to item messageNumber of selectedMessages
		set summary to summarize (content of theMessage as string) in 2
		set speakString to speakString & "Summary of message " & (messageNumber as string) & ": " & summary & return
	end repeat
end tell
say speakString